/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAchievement;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityDwarf;
import lotr.common.entity.npc.LOTRTradeEntries;
import lotr.common.entity.npc.LOTRTradeable;
import lotr.common.fac.LOTRFaction;
import lotr.common.quest.LOTRMiniQuest;
import lotr.common.quest.LOTRMiniQuestFactory;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class LOTREntityWickedDwarf
extends LOTREntityDwarf
implements LOTRTradeable.Smith {
    public static final LOTRFaction[] tradeFactions = new LOTRFaction[]{LOTRFaction.MORDOR, LOTRFaction.GUNDABAD, LOTRFaction.RHUDEL};
    private static ItemStack[] wickedWeapons = new ItemStack[]{new ItemStack(LOTRMod.swordWickedDwarf), new ItemStack(LOTRMod.battleaxeWickedDwarf), new ItemStack(LOTRMod.hammerWickedDwarf)};

    public LOTREntityWickedDwarf(World world) {
        super(world);
        this.addTargetTasks(true);
    }

    @Override
    public LOTRTradeEntries getBuyPool() {
        return LOTRTradeEntries.WICKED_DWARF_BUY;
    }

    @Override
    public LOTRTradeEntries getSellPool() {
        return LOTRTradeEntries.WICKED_DWARF_SELL;
    }

    @Override
    public void setupNPCGender() {
        this.familyInfo.setMale(true);
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        int i = this.field_70146_Z.nextInt(wickedWeapons.length);
        this.npcItemsInv.setMeleeWeapon(wickedWeapons[i].func_77946_l());
        this.npcItemsInv.setIdleItem(new ItemStack(LOTRMod.pickaxeWickedDwarf));
        if (this.field_70146_Z.nextInt(4) == 0) {
            this.func_70062_b(1, new ItemStack(LOTRMod.bootsDwarven));
            this.func_70062_b(2, new ItemStack(LOTRMod.legsDwarven));
            this.func_70062_b(3, new ItemStack(LOTRMod.bodyDwarven));
        }
        if (this.field_70146_Z.nextInt(4) == 0) {
            this.func_70062_b(1, new ItemStack(LOTRMod.bootsIronfist));
            this.func_70062_b(2, new ItemStack(LOTRMod.legsIronfist));
            this.func_70062_b(3, new ItemStack(LOTRMod.bodyIronfist));
        }
        if (this.field_70146_Z.nextInt(4) == 0) {
            this.func_70062_b(1, new ItemStack(LOTRMod.bootsStonefoot));
            this.func_70062_b(2, new ItemStack(LOTRMod.legsStonefoot));
            this.func_70062_b(3, new ItemStack(LOTRMod.bodyStonefoot));
        }
        if (this.field_70146_Z.nextInt(4) == 0) {
            this.func_70062_b(1, new ItemStack(LOTRMod.bootsBlacklock));
            this.func_70062_b(2, new ItemStack(LOTRMod.legsBlacklock));
            this.func_70062_b(3, new ItemStack(LOTRMod.bodyBlacklock));
        }
        if (this.field_70146_Z.nextInt(4) == 0) {
            this.func_70062_b(1, new ItemStack(LOTRMod.bootsStiffbeard));
            this.func_70062_b(2, new ItemStack(LOTRMod.legsStiffbeard));
            this.func_70062_b(3, new ItemStack(LOTRMod.bodyStiffbeard));
        }
        if (this.field_70146_Z.nextInt(4) == 0) {
            this.func_70062_b(1, new ItemStack(LOTRMod.wdboots));
            this.func_70062_b(2, new ItemStack(LOTRMod.wdlegs));
            this.func_70062_b(3, new ItemStack(LOTRMod.wdbody));
        } else {
            this.func_70062_b(1, null);
            this.func_70062_b(2, null);
            this.func_70062_b(3, null);
        }
        this.func_70062_b(4, null);
        return data;
    }

    @Override
    public LOTRFaction getFaction() {
        return LOTRFaction.MORDOR;
    }

    @Override
    protected LOTRAchievement getKillAchievement() {
        return LOTRAchievement.killWickedDwarf;
    }

    @Override
    public float getAlignmentBonus() {
        return 2.0f;
    }

    @Override
    public boolean canTradeWith(EntityPlayer entityplayer) {
        boolean hasAlignment = false;
        for (LOTRFaction f : tradeFactions) {
            if (LOTRLevelData.getData(entityplayer).getAlignment(f) < 100.0f) continue;
            hasAlignment = true;
            break;
        }
        return hasAlignment && this.isFriendly(entityplayer);
    }

    @Override
    public void onPlayerTrade(EntityPlayer entityplayer, LOTRTradeEntries.TradeType type, ItemStack itemstack) {
        LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.tradeWickedDwarf);
    }

    @Override
    public boolean shouldTraderRespawn() {
        return false;
    }

    @Override
    protected boolean canDwarfSpawnHere() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        return j > 62 && this.field_70170_p.func_147439_a(i, j - 1, k) == this.field_70170_p.func_72807_a((int)i, (int)k).field_76752_A;
    }

    @Override
    public boolean func_70601_bi() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        return j > 30 && this.field_70170_p.func_147439_a(i, j - 1, k) == Blocks.field_150433_aE;
    }

    @Override
    protected boolean canDwarfSpawnAboveGround() {
        return true;
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendlyAndAligned(entityplayer)) {
            if (this.canTradeWith(entityplayer)) {
                return "dwarf/wicked/friendly";
            }
            return "dwarf/wicked/neutral";
        }
        return "dwarf/wicked/hostile";
    }

    @Override
    public LOTRMiniQuest createMiniQuest() {
        return null;
    }

    @Override
    public LOTRMiniQuestFactory getBountyHelpSpeechDir() {
        return null;
    }
}

